/*
 * System log lib.
 * Copyright(c) 2014 Shenzhen TP-LINK Technologies Co.Ltd.
 * File    : tp_syslog.h
 * Author  : YGJ
 * Detail  : System log interface for C.
 * Version : 1.0
 * Date    : 3 Sep, 2014
 */

#ifndef __TP_SYSLOG_H__
#define __TP_SYSLOG_H__

#define SECONDS_ONE_DAY		(24*60*60)
#define SECONDS_ONE_HOUR 	(60*60)
#define SECONDS_ONE_MINUTE	(60)

#define TIME_STR_LEN		(32)
#define TYPE_NAME_LEN		(32)
#define MAX_LOG_SIZE		(256)
#define LEVEL_NAME_LEN		(16)
#define LOGD_UDP_PORT 		(50000)

typedef enum _LOG_TYPE_
{
	LOG_TYPE_WIFI_MOVE = 0,
	LOG_TYPE_LED_SCHEDULES,
	LOG_TYPE_WIFI_CLONE,
	LOG_TYPE_WIFI_SCHEDULES,
	LOG_TYPE_MAC_FILTER,
	LOG_TYPE_PARENTAL_CONTROLS,
	LOG_TYPE_DHCPC,
	LOG_TYPE_DHCPS,
	LOG_TYPE_OTHERS
}LOG_TYPE;

typedef enum _LOG_LEVEL_
{
	LOG_LEVEL_ERROR = 0,
	LOG_LEVEL_INFO
}LOG_LEVEL;

typedef struct _LOG_DATA_
{
	char time[TIME_STR_LEN];
	char type[TYPE_NAME_LEN];
	char level[LEVEL_NAME_LEN];
	char log[MAX_LOG_SIZE];
}LOG_DATA;

typedef struct _LOG_CMD_
{
	char type[TYPE_NAME_LEN];
	char level[LEVEL_NAME_LEN];
}LOG_CMD;

extern int tp_syslog(int type, int level, char *fmt, ...);

#endif  /* __TP_SYSLOG_H__ */
